package com.simpay.processor.client.model.operation;

import com.simpay.processor.client.enums.DsTvBundleType;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "DSTV bill payment request")
public class DsTvBillPaymentRequest {
  @Schema(description = "User reference")
  @NotNull(message = "The user reference is required")
  private UUID userReference;

  @Schema(description = "Start times bundle type")
  @NotNull(message = "The DsTv bundle type is required")
  private DsTvBundleType dsTvBundleType;

  @Schema(description = "Decoder number")
  @NotNull(message = "The decoder number is required")
  private String decoderNumber;
}
