package com.simpay.processor.client.model.operation;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Eneo bill payment request")
public class EneoBillPaymentRequest {
  @Schema(description = "User reference")
  @NotNull(message = "The user reference is required")
  private UUID userReference;

  @Schema(description = "Contract number")
  @NotNull(message = "The contract number is required")
  private String contractNumber;
}
