package com.simpay.processor.client.model.response;

import com.simpay.processor.client.enums.CanalPlusBundleType;
import com.simpay.processor.client.enums.PaymentProcessorStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Canal+ bill payment response")
public class CanalPlusBillPaymentResponse {
  @Schema(description = "User reference")
  private UUID userReference;

  @Schema(description = "payment provider id")
  private String paymentProviderId;

  @Schema(description = "payment message")
  private String message;

  @Schema(description = "payment status")
  private PaymentProcessorStatus status;

  @Schema(description = "payment amount")
  private BigDecimal amount;

  @Schema(description = "Debited Account Number")
  private String debitedAccountNumber;

  @Schema(description = "recipient account number")
  private String recipientAccountNumber;

  @Schema(description = "Canal+ bundle type")
  private CanalPlusBundleType canalPlusBundleType;
}
