package com.simpay.processor.client.model.response;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.UUID;
import lombok.*;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "Eneo verify contract number request")
public class EneoVerifyContractNumberResponse {
  @Schema(description = "User reference")
  @NotNull(message = "The user reference is required")
  private UUID userReference;

  @Schema(description = "Bill number")
  private String billNumber;

  @Schema(description = "Customer number")
  private String customerNumber;

  @Schema(description = "Contract number")
  private String contractNumber;

  @Schema(description = "Total amount")
  private BigDecimal totalAmount;
}
