package com.simpay.processor.client.model.response;

import com.simpay.processor.client.enums.PaymentProcessorStatus;
import com.simpay.processor.client.enums.StartTimesBundleType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;
import java.util.UUID;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Builder
@Schema(description = "START TIMES bill payment response")
public class StartTimesBillPaymentResponse {
  @Schema(description = "User reference")
  private UUID userReference;

  @Schema(description = "payment provider id")
  private String paymentProviderId;

  @Schema(description = "payment message")
  private String message;

  @Schema(description = "payment status")
  private PaymentProcessorStatus status;

  @Schema(description = "payment amount")
  private BigDecimal amount;

  @Schema(description = "Debited Account Number")
  private String debitedAccountNumber;

  @Schema(description = "recipient account number")
  private String recipientAccountNumber;

  @Schema(description = "Start times bundle type")
  private StartTimesBundleType startTimesBundleType;
}
