/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.configure;

import org.cattleframework.aop.resource.ClassResourceLoader;
import org.cattleframework.aop.resource.impl.ClassResourceLoaderImpl;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;

/**
 * Aop自动配置
 * 
 * @author orange
 *
 */
@AutoConfiguration
@EnableAspectJAutoProxy(exposeProxy = true, proxyTargetClass = true)
@Import({ AopBeanRegistrar.class, AopConfiguration.class })
public class AopAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ClassResourceLoader classResourceLoader(ResourceLoader resourceLoader) {
	return new ClassResourceLoaderImpl(resourceLoader);
    }
}