/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.configure;

import java.util.concurrent.atomic.AtomicBoolean;

import org.cattleframework.aop.context.SpringContext;
import org.cattleframework.aop.processor.SortedBeanPostProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

/**
 * Aop配置
 * 
 * @author orange
 *
 */
class AopConfiguration implements SortedBeanPostProcessor, BeanFactoryAware {

    private AtomicBoolean inited = new AtomicBoolean(false);

    private ConfigurableListableBeanFactory beanFactory;

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
	if (beanFactory instanceof ConfigurableListableBeanFactory listableBeanFactory) {
	    this.beanFactory = listableBeanFactory;
	}
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
	if (inited.compareAndSet(false, true)) {
	    SpringContext context = beanFactory.getBean(SpringContext.class);
	    SpringContext.set(context);
	}
	return bean;
    }

    @Override
    public int getOrder() {
	return Ordered.HIGHEST_PRECEDENCE + 2;
    }
}