/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.configure;

import org.springframework.beans.factory.FactoryBean;

import com.google.inject.Injector;
import com.google.inject.Key;

class GuiceFactoryBean<T> implements FactoryBean<T> {

    private Key<T> key;

    private Class<T> beanType;

    private boolean singleton;

    private Injector injector;

    public void setKey(Key<T> key) {
	this.key = key;
    }

    public void setBeanType(Class<T> beanType) {
	this.beanType = beanType;
    }

    public void setSingleton(boolean singleton) {
	this.singleton = singleton;
    }

    public void setInjector(Injector injector) {
	this.injector = injector;
    }

    @Override
    public T getObject() throws Exception {
	return (T) injector.getInstance(key);
    }

    @Override
    public Class<?> getObjectType() {
	return beanType;
    }

    @Override
    public boolean isSingleton() {
	return singleton;
    }
}