/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.context;

import org.cattleframework.aop.guice.GuiceBeanFactory;
import org.cattleframework.aop.resource.ClassResourceLoader;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;

/**
 * Spring上下文
 * 
 * @author orange
 *
 */
public class SpringContext {

    private static SpringContext springContext;

    public static SpringContext get() {
	return springContext;
    }

    public static void set(SpringContext context) {
	springContext = context;
    }

    private final ConfigurableListableBeanFactory beanFactory;

    private final Environment environment;

    private final ClassResourceLoader classResourceLoader;

    private final GuiceBeanFactory guiceBeanFactory;

    public SpringContext(ConfigurableListableBeanFactory beanFactory, Environment environment,
	    ClassResourceLoader classResourceLoader, @Nullable GuiceBeanFactory guiceBeanFactory) {
	this.beanFactory = beanFactory;
	this.environment = environment;
	this.classResourceLoader = classResourceLoader;
	this.guiceBeanFactory = guiceBeanFactory;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
	return beanFactory;
    }

    public Environment getEnvironment() {
	return environment;
    }

    public ClassResourceLoader getClassResourceLoader() {
	return classResourceLoader;
    }

    public GuiceBeanFactory getGuiceBeanFactory() {
	return guiceBeanFactory;
    }

    public String getApplicationName() {
	return environment.getProperty("spring.application.name", "");
    }

    public String getContextPath() {
	return environment.getProperty("server.servlet.context-path", "");
    }
}