/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.event;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;

/**
 * 上下文初始化事件
 * 
 * @author orange
 *
 */
public interface ContextInitializeEvent {

    /**
     * 执行
     * 
     * @param beanFactory Bean工厂
     * @param environment 环境
     * @throws Throwable 异常
     */
    void execute(ConfigurableListableBeanFactory beanFactory, Environment environment) throws Throwable;
}