/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.event;

import org.springframework.boot.ConfigurableBootstrapContext;

/**
 * 启动事件
 * 
 * @author orange
 *
 */
public interface StartingEvent {

    /**
     * 执行
     * 
     * @param context 启动上下文
     * @param args    参数
     * @throws Throwable 异常
     */
    void execute(ConfigurableBootstrapContext context, String[] args) throws Throwable;
}