/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.guice;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;

/**
 * Guice的Bean工厂
 * 
 * @author orange
 *
 */
public class GuiceBeanFactory {

    private final Injector injector;

    public GuiceBeanFactory(Injector injector) {
	this.injector = injector;
    }

    public <T> T getInstance(Class<T> type) {
	if (injector != null) {
	    Binding<T> binding = injector.getExistingBinding(Key.get(type));
	    if (binding != null) {
		Provider<T> provider = binding.getProvider();
		return provider.get();
	    }
	}
	return null;
    }
}