/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.listener;

import java.util.Set;

import org.apache.commons.collections4.CollectionUtils;
import org.cattleframework.aop.event.StartingEvent;
import org.cattleframework.aop.utils.ServiceLoaderUtils;
import org.cattleframework.exception.CommonException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.event.ApplicationStartingEvent;
import org.springframework.context.ApplicationListener;

/**
 * 启动事件监听器
 * 
 * @author orange
 *
 */
public class StartingEventListener implements ApplicationListener<ApplicationStartingEvent> {

    @Override
    public void onApplicationEvent(ApplicationStartingEvent event) {
	Set<StartingEvent> startingEvents;
	try {
	    startingEvents = ServiceLoaderUtils.getService(StartingEvent.class);
	} catch (CommonException e) {
	    throw ExceptionWrapUtils.wrapRuntime(e);
	}
	if (CollectionUtils.isNotEmpty(startingEvents)) {
	    processStartingEvent(event.getBootstrapContext(), event.getArgs(), startingEvents);
	}
    }

    private void processStartingEvent(ConfigurableBootstrapContext context, String[] args,
	    Set<StartingEvent> startingEvents) {
	startingEvents.stream().forEachOrdered(startingEvent -> {
	    try {
		System.out.println("处理启动事件,类名:" + startingEvent.getClass().getName());
		startingEvent.execute(context, args);
	    } catch (Throwable e) {
		throw ExceptionWrapUtils.wrapRuntime(e);
	    }
	});
    }
}