package org.cattleframework.aop.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.aopalliance.intercept.MethodInterceptor;
import org.cattleframework.aop.constants.ProxyMode;
import org.cattleframework.aop.constants.ScanMode;

/**
 * 默认自动扫描代理
 * 
 * @author orange
 *
 */
public class DefaultAutoScanProxy extends AbstractAutoScanProxy {

    private static final long serialVersionUID = 1L;

    public DefaultAutoScanProxy(String[] scanPackages, ProxyMode proxyMode, ScanMode scanMode) {
	super(scanPackages, proxyMode, scanMode);
    }

    @Override
    protected MethodInterceptor[] getAdditionalInterceptors(Class<?> targetClass) {
	return null;
    }

    @Override
    protected Class<? extends MethodInterceptor>[] getCommonInterceptors() {
	return null;
    }

    @Override
    protected String[] getCommonInterceptorNames() {
	return null;
    }

    @Override
    protected Class<? extends Annotation>[] getMethodAnnotations() {
	return null;
    }

    @Override
    protected void methodAnnotationScanned(Class<?> targetClass, Method method,
	    Class<? extends Annotation> methodAnnotation) {
    }

    @Override
    protected Class<? extends Annotation>[] getClassAnnotations() {
	return null;
    }

    @Override
    protected void classAnnotationScanned(Class<?> targetClass, Class<? extends Annotation> classAnnotation) {
    }
}