/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.resource;

import java.util.Set;

/**
 * 类资源加载器
 * 
 * @author orange
 *
 */
public interface ClassResourceLoader {

    /**
     * 得到资源
     * 
     * @param location 资源路径
     * @return 资源
     */
    Resource getResource(String location);

    /**
     * 得到资源
     * 
     * @param locations    资源路径
     * @param resourceName 资源名称
     * @return 资源
     */
    Resource getResource(String[] locations, String resourceName);

    /**
     * 得到资源
     * 
     * @param locations    资源路径
     * @param resourceName 资源名称
     * @param allowDefault 允许缺省
     * @return 资源
     */
    Resource getResource(String[] locations, String resourceName, boolean allowDefault);

    /**
     * 得到资源
     * 
     * @param locationPattern 资源路径表达式
     * @return 资源
     */
    Set<Resource> getResources(String locationPattern);

    /**
     * 根据后缀名得到资源
     * 
     * @param locationPattern 资源路径表达式
     * @param suffix          后缀名
     * @return 资源
     */
    Set<Resource> getResources(String locationPattern, String suffix);
}