/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.resource;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

/**
 * 资源
 * 
 * @author orange
 *
 */
public interface Resource {

    /**
     * 获得文件名
     * 
     * @return 文件名
     */
    String getFileName();

    /**
     * 获得Url
     * 
     * @return Url
     */
    URL getUrl();

    /**
     * 获得路径
     * 
     * @return 路径
     */
    String getPath();

    /**
     * 获得描述
     * 
     * @return 描述
     */
    String getDescription();

    /**
     * 获得输入流
     * 
     * @return 输入流
     */
    InputStream getInputStream();

    /**
     * 获得Uri
     * 
     * @return Uri
     */
    URI getUri();

    /**
     * 是否文件
     * 
     * @return 是否文件
     */
    boolean isFile();

    /**
     * 获得文件
     * 
     * @return 文件
     */
    File getFile();

    /**
     * 最后修改时间
     * 
     * @return 最后修改时间
     */
    long lastModified();

    /**
     * 内容长度
     * 
     * @return 内容长度
     */
    long contentLength();
}