/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.aop.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;

import org.cattleframework.exception.CommonException;
import org.cattleframework.exception.ExceptionWrapUtils;

/**
 * 简单反射工具
 * 
 * @author orange
 *
 */
public class SimpleReflectUtils {

    public static boolean isClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return !Modifier.isInterface(modifier) && !Modifier.isAbstract(modifier);
    }

    public static boolean implementsInterface(Class<?> clazz, Class<?> intf) {
	if (!isAbstractClass(intf) && !isInterfaceClass(intf)) {
	    return false;
	}
	return intf.isAssignableFrom(clazz);
    }

    public static boolean isInterfaceClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return Modifier.isInterface(modifier);
    }

    public static boolean isAbstractClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return Modifier.isAbstract(modifier);
    }

    public static boolean isPublicClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return Modifier.isPublic(modifier);
    }

    public static boolean isFinalClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return Modifier.isFinal(modifier);
    }

    public static boolean isStaticClass(Class<?> clazz) {
	int modifier = clazz.getModifiers();
	return Modifier.isStatic(modifier);
    }

    public static boolean classExists(String className) {
	boolean exists = true;
	try {
	    Class.forName(className);
	} catch (ClassNotFoundException e) {
	    exists = false;
	}
	return exists;
    }

    public static <T> T instance(Class<T> type) throws CommonException {
	try {
	    return type.getDeclaredConstructor().newInstance();
	} catch (InstantiationException | IllegalAccessException | IllegalArgumentException | InvocationTargetException
		| NoSuchMethodException | SecurityException e) {
	    throw ExceptionWrapUtils.wrap(e);
	}
    }
}