/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.processor;

import org.cattleframework.cloud.config.properties.BaseCloudConfigProperties;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;

/**
 * 服务配置的属性配置适配器
 * 
 * @author orange
 *
 */
public interface ConfigPropertiesProcessor {

    /**
     * 是否需要处理
     * 
     * @param targetPropertiesClass 目标属性配置类
     * @return 是否需要处理
     */
    boolean needProcess(Class<?> targetPropertiesClass);

    /**
     * 获得源属性配置类
     * 
     * @return 源属性配置类
     */
    Class<? extends BaseCloudConfigProperties> getSourcePropertiesClass();

    /**
     * 处理
     * 
     * @param beanFactory           Bean工厂
     * @param environment           环境
     * @param targetPropertiesBean  目标属性配置Bean
     * @param cloudConfigProperties 服务配置数据源属性配置
     */
    void process(ConfigurableListableBeanFactory beanFactory, Environment environment, Object targetPropertiesBean,
	    BaseCloudConfigProperties cloudConfigProperties);
}