/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.properties;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

import jakarta.annotation.PostConstruct;

/**
 * 服务配置的属性配置基础
 * 
 * @author orange
 *
 */
public abstract class BaseCloudConfigProperties {

    /**
     * 覆盖来自环境
     * 
     * @param environment 环境
     */
    protected abstract void overrideFromEnv(Environment environment);

    private String address;

    @Autowired
    private Environment environment;

    @PostConstruct
    public void init() throws Exception {
	overrideFromEnv(environment);
    }

    public String getAddress() {
	return address;
    }

    public void setAddress(String address) {
	this.address = address;
    }
}