/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.processor;

import org.apache.commons.lang3.ClassUtils;
import org.cattleframework.cloud.config.rule.property.RulePropertyDelegate;

/**
 * 规则Bean信息
 * 
 * @author orange
 *
 */
public class RuleBeanInfo<T> {

    private final String categoryName;

    private final Class<T> ruleClass;

    private final RulePropertyDelegate<T, ?> rulePropertyDelegate;

    private final boolean share;

    private final String ruleName;

    public RuleBeanInfo(String categoryName, Class<T> ruleClass, RulePropertyDelegate<T, ?> rulePropertyDelegate) {
	this(categoryName, ruleClass, rulePropertyDelegate, true);
    }

    public RuleBeanInfo(String categoryName, Class<T> ruleClass, RulePropertyDelegate<T, ?> rulePropertyDelegate,
	    boolean share) {
	this.categoryName = categoryName;
	ruleName = ClassUtils.getSimpleName(ruleClass);
	this.ruleClass = ruleClass;
	this.rulePropertyDelegate = rulePropertyDelegate;
	this.share = share;
    }

    public String getCategoryName() {
	return categoryName;
    }

    public Class<T> getRuleClass() {
	return ruleClass;
    }

    public String getRuleName() {
	return ruleName;
    }

    public RulePropertyDelegate<T, ?> getRulePropertyDelegate() {
	return rulePropertyDelegate;
    }

    public boolean isShare() {
	return share;
    }
}