/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.processor;

import java.util.Map;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.core.env.Environment;

/**
 * 规则配置适配器
 * 
 * @author orange
 *
 */
public interface RuleConfigResourceProcessor {

    /**
     * 获得工厂Bean名称
     * 
     * @return 工厂Bean名称
     */
    String getFactoryBeanName();

    /**
     * 获得规则配置资源属性
     * 
     * @param beanFactory      Bean工厂
     * @param environment      环境
     * @param ruleCategoryName 规则分类名称
     * @param ruleFileName     规则文件名称
     * @return 规则配置数据源属性
     */
    Map<String, Object> getRuleConfigResourceProps(DefaultListableBeanFactory beanFactory, Environment environment,
	    String ruleCategoryName, String ruleFileName);
}