/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.processor;

import org.cattleframework.cloud.config.rule.resource.BaseRuleConfigResource;

/**
 * 规则适配器
 * 
 * @author orange
 *
 */
public interface RuleProcessor {

    /**
     * 获得规则Bean信息
     * 
     * @return 规则Bean信息
     */
    RuleBeanInfo<?>[] getBeanInfos();

    /**
     * 获得规则转换器工厂Bean名称
     * 
     * @param fileExtension 规则的文件扩展名
     * @return 规则转换器工厂Bean名称
     */
    String getConverterFactoryBeanName(String fileExtension);

    /**
     * 注册属性
     * 
     * @param ruleConfigResource 规则配置资源
     */
    void registerProperty(BaseRuleConfigResource<?> ruleConfigResource);
}