/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.property;

/**
 * 属性代理
 * 
 * @author orange
 *
 * @param <T> 类的类型
 */
public interface RulePropertyDelegate<T, P> {

    /**
     * 获得属性
     * 
     * @return 属性
     */
    P getRuleProperty();

    /**
     * 更新值
     * 
     * @param newValue 新值
     */
    void updateValue(T newValue);
}