/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.resource;

import org.apache.commons.lang3.StringUtils;
import org.cattleframework.cloud.config.rule.processor.RuleConverter;
import org.cattleframework.cloud.config.rule.property.RulePropertyDelegate;
import org.cattleframework.exception.CommonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 规则配置资源的基础
 * 
 * @author orange
 *
 * @param <T> 类的类型
 */
public abstract class BaseRuleConfigResource<T> {

    private static final Logger logger = LoggerFactory.getLogger(BaseRuleConfigResource.class);

    /**
     * 关闭
     * 
     * @throws CommonException 异常
     */
    public abstract void close() throws CommonException;

    private final RulePropertyDelegate<T, ?> rulePropertyDelegate;

    private final RuleConverter<T> ruleConverter;

    public BaseRuleConfigResource(RulePropertyDelegate<T, ?> rulePropertyDelegate, RuleConverter<T> ruleConverter) {
	this.rulePropertyDelegate = rulePropertyDelegate;
	this.ruleConverter = ruleConverter;
    }

    public RulePropertyDelegate<T, ?> getRulePropertyDelegate() {
	return rulePropertyDelegate;
    }

    protected void updateValue(String content) {
	T ruleObj = null;
	if (StringUtils.isNotBlank(content)) {
	    try {
		ruleObj = ruleConverter.convert(content);
	    } catch (Throwable e) {
		logger.error(String.format("规则转换失败:%s", e.getMessage()));
		return;
	    }
	}
	rulePropertyDelegate.updateValue(ruleObj);
    }
}