/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.cloud.config.rule.resource;

import org.cattleframework.cloud.config.rule.processor.RuleConverter;
import org.cattleframework.cloud.config.rule.property.RulePropertyDelegate;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

/**
 * 数据源工厂Bean抽象
 * 
 * @author orange
 *
 * @param <T> 类的类型
 */
public abstract class BaseRuleConfigResourceFactoryBean<T, D>
	implements FactoryBean<D>, InitializingBean, DisposableBean {

    private RulePropertyDelegate<T, ?> rulePropertyDelegate;

    private RuleConverter<T> ruleConverter;

    public RulePropertyDelegate<T, ?> getRulePropertyDelegate() {
	return rulePropertyDelegate;
    }

    public void setRulePropertyDelegate(RulePropertyDelegate<T, ?> rulePropertyDelegate) {
	this.rulePropertyDelegate = rulePropertyDelegate;
    }

    public RuleConverter<T> getRuleConverter() {
	return ruleConverter;
    }

    public void setRuleConverter(RuleConverter<T> ruleConverter) {
	this.ruleConverter = ruleConverter;
    }
}