/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.config.nacos;

import com.alibaba.cloud.commons.lang.StringUtils;
import org.cattleframework.cloud.config.properties.BaseCloudConfigProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="cattle.cloud.config.nacos")
public class NacosCloudConfigProperties
extends BaseCloudConfigProperties {
    @Value(value="${spring.cloud.nacos.config.namespace:public}")
    private String namespace;
    @Value(value="${spring.cloud.nacos.username:}")
    private String username;
    @Value(value="${spring.cloud.nacos.password:}")
    private String password;
    @Value(value="${spring.cloud.nacos.config.group:DEFAULT_GROUP}")
    private String group;
    private long readTimeout = 3000L;

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    protected void overrideFromEnv(Environment environment) {
        if (StringUtils.isBlank((CharSequence)this.getAddress())) {
            String serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.config.server-addr:}");
            if (StringUtils.isBlank((CharSequence)serverAddr)) {
                serverAddr = environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:127.0.0.1:8848}");
            }
            this.setAddress(serverAddr);
        }
    }
}

