/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.config.nacos.processor;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.cloud.config.nacos.NacosCloudConfigProperties;
import org.cattleframework.cloud.config.processor.ConfigPropertiesProcessor;
import org.cattleframework.cloud.config.properties.BaseCloudConfigProperties;
import org.cattleframework.exception.CommonRuntimeException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.env.Environment;

public class NacosConfigPropertiesProcessor
implements ConfigPropertiesProcessor {
    public boolean needProcess(Class<?> targetPropertiesClass) {
        return NacosConfigProperties.class == targetPropertiesClass;
    }

    public Class<? extends BaseCloudConfigProperties> getSourcePropertiesClass() {
        return NacosCloudConfigProperties.class;
    }

    public void process(ConfigurableListableBeanFactory beanFactory, Environment environment, Object targetPropertiesBean, BaseCloudConfigProperties cloudDataSourceProperties) {
        NacosCloudConfigProperties nacosCloudConfigProperties = (NacosCloudConfigProperties)cloudDataSourceProperties;
        if (targetPropertiesBean instanceof NacosConfigProperties) {
            NacosConfigProperties nacosConfigProperties = (NacosConfigProperties)targetPropertiesBean;
            this.processNacosConfigProperties(beanFactory, environment, nacosConfigProperties, nacosCloudConfigProperties);
        }
    }

    private void processNacosConfigProperties(ConfigurableListableBeanFactory beanFactory, Environment environment, NacosConfigProperties nacosConfigProperties, NacosCloudConfigProperties nacosCloudConfigProperties) {
        if (StringUtils.isBlank((CharSequence)nacosCloudConfigProperties.getAddress())) {
            throw new CommonRuntimeException("Nacos\u5730\u5740\u6ca1\u6709\u8bbe\u7f6e");
        }
        nacosConfigProperties.setServerAddr(nacosCloudConfigProperties.getAddress());
        nacosConfigProperties.setNamespace(nacosCloudConfigProperties.getNamespace());
        nacosConfigProperties.setUsername(nacosCloudConfigProperties.getUsername());
        nacosConfigProperties.setPassword(nacosCloudConfigProperties.getPassword());
        nacosConfigProperties.setGroup(nacosCloudConfigProperties.getGroup());
    }
}

