/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.config.nacos.resource;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.cloud.config.rule.processor.RuleConverter;
import org.cattleframework.cloud.config.rule.property.RulePropertyDelegate;
import org.cattleframework.cloud.config.rule.resource.BaseRuleConfigResource;
import org.cattleframework.exception.CommonException;
import org.cattleframework.exception.CommonRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRuleConfigResource<T>
extends BaseRuleConfigResource<T> {
    private static final Logger logger = LoggerFactory.getLogger(NacosRuleConfigResource.class);
    private final Listener configListener;
    private final String groupId;
    private final String dataId;
    private final ConfigService configService;
    private final ExecutorService executor;

    public NacosRuleConfigResource(NacosConfigManager nacosConfigManager, ThreadFactory threadFactory, String groupId, String dataId, long readTimeout, RulePropertyDelegate<T, ?> rulePropertyDelegate, RuleConverter<T> ruleConverter) {
        super(rulePropertyDelegate, ruleConverter);
        if (StringUtils.isBlank((CharSequence)groupId) || StringUtils.isBlank((CharSequence)dataId)) {
            throw new CommonRuntimeException(String.format("\u9519\u8bef\u53c2\u6570:groupId=[%s],dataId=[%s]", groupId, dataId));
        }
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), threadFactory, new ThreadPoolExecutor.DiscardOldestPolicy());
        this.groupId = groupId;
        this.dataId = dataId;
        this.configService = nacosConfigManager.getConfigService();
        this.configListener = new Listener(){

            public Executor getExecutor() {
                return NacosRuleConfigResource.this.executor;
            }

            public void receiveConfigInfo(String configInfo) {
                NacosRuleConfigResource.this.updateValue(configInfo);
            }
        };
        try {
            String content = this.configService.getConfig(dataId, groupId, readTimeout);
            if (StringUtils.isNotBlank((CharSequence)content)) {
                this.updateValue(content);
            }
        }
        catch (NacosException e) {
            logger.error(String.format("\u83b7\u5f97Nacos\u89c4\u5219\u914d\u7f6e\u8d44\u6e90(Data ID:%s,Group:%s)\u65f6,\u53d1\u751f\u5f02\u5e38:%s", dataId, groupId, e.getMessage()), (Throwable)e);
        }
        try {
            logger.debug("\u5efa\u7acbNacos\u89c4\u5219\u914d\u7f6e\u8d44\u6e90(dataId:{},groupId:{})", (Object)dataId, (Object)groupId);
            this.configService.addListener(dataId, groupId, this.configListener);
        }
        catch (NacosException e) {
            logger.error(String.format("\u5efa\u7acbNacos\u89c4\u5219\u914d\u7f6e\u8d44\u6e90(Data ID:%s,Group:%s)\u65f6,\u53d1\u751f\u5f02\u5e38:%s", dataId, groupId, e.getMessage()), (Throwable)e);
        }
    }

    public void close() throws CommonException {
        if (this.configService != null) {
            this.configService.removeListener(this.dataId, this.groupId, this.configListener);
        }
        this.executor.shutdownNow();
        logger.debug("\u5173\u95edNacos\u89c4\u5219\u914d\u7f6e\u8d44\u6e90(Data ID:{},Group:{})", (Object)this.dataId, (Object)this.groupId);
    }
}

