/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.enhancement;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Collections;
import java.util.List;
import org.cattleframework.cloud.enhancement.feign.EnhancedLoadBalancerFeignRequestTransformer;
import org.cattleframework.cloud.enhancement.feign.FeignBeanPostProcessor;
import org.cattleframework.cloud.enhancement.filter.ReactiveFilter;
import org.cattleframework.cloud.enhancement.filter.ServletFilter;
import org.cattleframework.cloud.enhancement.plugin.DefaultPluginRunner;
import org.cattleframework.cloud.enhancement.plugin.Plugin;
import org.cattleframework.cloud.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.enhancement.resttemplate.RestTemplateInterceptor;
import org.cattleframework.cloud.enhancement.resttemplate.RestTemplateLoadBalancerRequestTransformer;
import org.cattleframework.cloud.enhancement.scg.GatewayFilter;
import org.cattleframework.cloud.enhancement.webclient.WebClientExchangeFilterFunction;
import org.cattleframework.cloud.enhancement.webclient.WebClientLoadBalancerClientRequestTransformer;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@ConditionalOnProperty(value={"cattle.cloud.enhancement.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfiguration
public class EnhancementAutoConfiguration {
    @Bean
    @Lazy
    public PluginRunner pluginRunner(@Autowired(required=false) List<Plugin> plugins, @Autowired(required=false) Registration registration) {
        return new DefaultPluginRunner(plugins, registration);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactiveFilterConfig {
        @Bean
        public ReactiveFilter reactiveFilter(@Lazy PluginRunner pluginRunner) {
            return new ReactiveFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletFilterConfig {
        @Bean
        public FilterRegistrationBean<ServletFilter> servletFilterRegistrationBean(ServletFilter servletFilter) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)servletFilter, new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(-2147483638);
            return filterRegistrationBean;
        }

        @Bean
        public ServletFilter servletFilter(@Lazy PluginRunner pluginRunner) {
            return new ServletFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
    @Role(value=2)
    public static class GatewayAutoConfiguration {
        @Bean
        @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        public GatewayFilter gatewayFilter(@Lazy PluginRunner pluginRunner) {
            return new GatewayFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public static class WebClientAutoConfiguration {
        @Autowired(required=false)
        private List<WebClient.Builder> webClientBuilder = Collections.emptyList();

        @Bean
        public WebClientExchangeFilterFunction webClientExchangeFilterFunction(@Lazy PluginRunner pluginRunner) {
            return new WebClientExchangeFilterFunction(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton initializingWebClient(WebClientExchangeFilterFunction webClientExchangeFilterFunction) {
            return () -> this.webClientBuilder.forEach(webClient -> webClient.filter((ExchangeFilterFunction)webClientExchangeFilterFunction));
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer"})
        public WebClientLoadBalancerClientRequestTransformer webClientLoadBalancerClientRequestTransformer() {
            return new WebClientLoadBalancerClientRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    public static class RestTemplateAutoConfiguration {
        @Autowired(required=false)
        @LoadBalanced
        private List<RestTemplate> restTemplates = Collections.emptyList();

        @Bean
        public RestTemplateInterceptor restTemplateInterceptor(@Lazy PluginRunner pluginRunner) {
            return new RestTemplateInterceptor(pluginRunner);
        }

        @Bean
        public SmartInitializingSingleton initializingRestTemplate(RestTemplateInterceptor restTemplateInterceptor) {
            return () -> {
                for (RestTemplate restTemplate : this.restTemplates) {
                    restTemplate.getInterceptors().add(restTemplateInterceptor);
                }
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer"})
        public RestTemplateLoadBalancerRequestTransformer restTemplateLoadBalancerRequestTransformer() {
            return new RestTemplateLoadBalancerRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @Role(value=2)
    public static class FeignClientAutoConfiguration {
        @Bean
        public FeignBeanPostProcessor feignBeanPostProcessor(@Lazy PluginRunner pluginRunner) {
            return new FeignBeanPostProcessor(pluginRunner);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.openfeign.loadbalancer.LoadBalancerFeignRequestTransformer"})
        public EnhancedLoadBalancerFeignRequestTransformer enhancedLoadBalancerFeignRequestTransformer() {
            return new EnhancedLoadBalancerFeignRequestTransformer();
        }
    }
}

