/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.enhancement.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.cattleframework.cloud.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.enhancement.plugin.PluginType;
import org.cattleframework.cloud.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.enhancement.plugin.ResponseContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.filter.OncePerRequestFilter;

public class ServletFilter
extends OncePerRequestFilter {
    private final PluginRunner pluginRunner;

    public ServletFilter(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        PluginContext pluginContext = new PluginContext();
        HttpHeaders requestHeaders = new HttpHeaders();
        Enumeration requestHeaderNames = request.getHeaderNames();
        if (requestHeaderNames != null) {
            while (requestHeaderNames.hasMoreElements()) {
                String requestHeaderName = (String)requestHeaderNames.nextElement();
                requestHeaders.addAll(requestHeaderName, Collections.list(request.getHeaders(requestHeaderName)));
            }
        }
        RequestContext requestContext = RequestContext.builder().httpHeaders(requestHeaders).httpMethod(HttpMethod.valueOf((String)request.getMethod())).url(URI.create(request.getRequestURL().toString())).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        this.pluginRunner.run(PluginType.Server.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            HttpHeaders responseHeaders = new HttpHeaders();
            Collection responseHeaderNames = response.getHeaderNames();
            if (responseHeaderNames != null) {
                for (String responseHeaderName : responseHeaderNames) {
                    responseHeaders.addAll(responseHeaderName, new ArrayList(response.getHeaders(responseHeaderName)));
                }
            }
            ResponseContext responseContext = ResponseContext.builder().httpStatus(response.getStatus()).httpHeaders(responseHeaders).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Server.POST, pluginContext);
        }
        catch (ServletException | IOException e) {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable(e);
            this.pluginRunner.run(PluginType.Server.EXCEPTION, pluginContext);
            throw e;
        }
        finally {
            this.pluginRunner.run(PluginType.Server.FINALLY, pluginContext);
        }
    }
}

