/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.enhancement.resttemplate;

import java.io.IOException;
import org.cattleframework.cloud.discovery.context.DataContextHolder;
import org.cattleframework.cloud.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.enhancement.plugin.PluginType;
import org.cattleframework.cloud.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.enhancement.plugin.ResponseContext;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class RestTemplateInterceptor
implements ClientHttpRequestInterceptor {
    private final PluginRunner pluginRunner;

    public RestTemplateInterceptor(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        PluginContext pluginContext = new PluginContext();
        RequestContext requestContext = RequestContext.builder().httpHeaders(request.getHeaders()).httpMethod(request.getMethod()).url(request.getURI()).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        pluginContext.setTargetServiceInstance(DataContextHolder.get().getInstance(), request.getURI());
        this.pluginRunner.run(PluginType.Client.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            ClientHttpResponse response = execution.execute(request, body);
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            ResponseContext responseContext = ResponseContext.builder().httpStatus(response.getStatusCode().value()).httpHeaders(response.getHeaders()).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Client.POST, pluginContext);
            ClientHttpResponse clientHttpResponse = response;
            return clientHttpResponse;
        }
        catch (IOException e) {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable(e);
            this.pluginRunner.run(PluginType.Client.EXCEPTION, pluginContext);
            throw e;
        }
        finally {
            this.pluginRunner.run(PluginType.Client.FINALLY, pluginContext);
        }
    }
}

