/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.enhancement.webclient;

import org.cattleframework.cloud.discovery.context.DataContextHolder;
import org.cattleframework.cloud.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.enhancement.plugin.PluginType;
import org.cattleframework.cloud.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.enhancement.plugin.ResponseContext;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class WebClientExchangeFilterFunction
implements ExchangeFilterFunction {
    private final PluginRunner pluginRunner;

    public WebClientExchangeFilterFunction(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        PluginContext pluginContext = new PluginContext();
        RequestContext requestContext = RequestContext.builder().httpHeaders(request.headers()).httpMethod(request.method()).url(request.url()).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        pluginContext.setTargetServiceInstance(DataContextHolder.get().getInstance(), request.url());
        this.pluginRunner.run(PluginType.Client.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        return next.exchange(request).doOnSuccess(response -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            ResponseContext responseContext = ResponseContext.builder().httpStatus(response.statusCode().value()).httpHeaders(response.headers().asHttpHeaders()).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Client.POST, pluginContext);
        }).doOnError(e -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable((Throwable)e);
            this.pluginRunner.run(PluginType.Client.EXCEPTION, pluginContext);
        }).doFinally(v -> this.pluginRunner.run(PluginType.Client.FINALLY, pluginContext));
    }
}

