/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.quartz;

import org.cattleframework.quartz.QuartzProperties;
import org.cattleframework.quartz.service.QuartzSchedulerFactoryBeanCustomizer;
import org.cattleframework.quartz.service.QuartzService;
import org.cattleframework.quartz.service.QuartzServiceInitializer;
import org.quartz.Scheduler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration
@EnableConfigurationProperties(value={QuartzProperties.class})
@ConditionalOnClass(value={Scheduler.class, SchedulerFactoryBean.class, PlatformTransactionManager.class})
@ConditionalOnProperty(prefix="quartz", name={"enabled"}, matchIfMissing=true)
@Import(value={QuartzSchedulerFactoryBeanCustomizer.class})
public class QuartzAutoConfiguration {
    @Bean
    public QuartzService quartzService(Scheduler scheduler, QuartzProperties quartzProperties) {
        return new QuartzService(scheduler, quartzProperties);
    }

    @Bean
    public QuartzServiceInitializer quartzServiceInitializer(QuartzService quartzService) {
        return new QuartzServiceInitializer(quartzService);
    }
}

