/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.quartz.service;

import java.util.Date;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.aop.context.SpringContext;
import org.cattleframework.exception.CommonException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.cattleframework.quartz.QuartzProperties;
import org.cattleframework.quartz.annotation.ConfigureQuartzJob;
import org.cattleframework.quartz.annotation.CronQuartzJob;
import org.cattleframework.quartz.annotation.QuartzJob;
import org.cattleframework.quartz.constant.TriggerType;
import org.cattleframework.quartz.job.Job;
import org.cattleframework.quartz.service.QuartzJobInfo;
import org.cattleframework.utils.auxiliary.DataConvertUtils;
import org.cattleframework.utils.reflect.constant.ClassType;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Profiles;

public class QuartzService {
    private static final Logger logger = LoggerFactory.getLogger(QuartzService.class);
    private static final String QUARTZ_GROUP = "cattle-scheduler";
    private Scheduler scheduler;
    private QuartzProperties quartzProperties;

    public QuartzService(Scheduler scheduler, QuartzProperties quartzProperties) {
        this.scheduler = scheduler;
        this.quartzProperties = quartzProperties;
    }

    public void add(QuartzJob quartzJob, Class<? extends Job> jobClass) throws CommonException {
        String name;
        boolean oper = true;
        if (null != quartzJob.profile() && quartzJob.profile().length > 0) {
            oper = SpringContext.get().getEnvironment().acceptsProfiles(Profiles.of((String[])quartzJob.profile()));
        }
        if (oper && StringUtils.isNotBlank((CharSequence)quartzJob.enabledProperty())) {
            String strEnabledProperty = SpringContext.get().getEnvironment().getProperty(quartzJob.enabledProperty());
            boolean match = StringUtils.isNotBlank((CharSequence)strEnabledProperty) ? BooleanUtils.toBoolean((String)strEnabledProperty) : quartzJob.enabledMatchIfMissing();
            boolean bl = oper = match == quartzJob.matchConditionalValue();
        }
        if (oper && StringUtils.isNotBlank((CharSequence)(name = this.getJobName(quartzJob.name(), jobClass)))) {
            if (null == quartzJob.type()) {
                throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u7684\u89e6\u53d1\u5668\u7c7b\u578b\u4e3a\u7a7a");
            }
            if (quartzJob.interval() <= 0) {
                throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u7684\u95f4\u9694\u5fc5\u987b\u5927\u4e8e\u96f6");
            }
            SimpleTrigger simpleTrigger = this.getSimpleTrigger(name, quartzJob.description(), quartzJob.type(), quartzJob.interval(), quartzJob.immediately());
            JobDetail jobDetail = this.getJobDetail(name, quartzJob.description(), jobClass);
            this.scheduleJob(name, jobDetail, (Trigger)simpleTrigger);
        }
    }

    public void add(CronQuartzJob cronQuartzJob, Class<? extends Job> jobClass) throws CommonException {
        String name;
        boolean oper = true;
        if (null != cronQuartzJob.profile() && cronQuartzJob.profile().length > 0) {
            oper = SpringContext.get().getEnvironment().acceptsProfiles(Profiles.of((String[])cronQuartzJob.profile()));
        }
        if (oper && StringUtils.isNotBlank((CharSequence)cronQuartzJob.enabledProperty())) {
            String strEnabledProperty = SpringContext.get().getEnvironment().getProperty(cronQuartzJob.enabledProperty());
            oper = StringUtils.isNotBlank((CharSequence)strEnabledProperty) ? BooleanUtils.toBoolean((String)strEnabledProperty) : cronQuartzJob.enabledMatchIfMissing();
        }
        if (oper && StringUtils.isNotBlank((CharSequence)(name = this.getJobName(cronQuartzJob.name(), jobClass)))) {
            if (StringUtils.isBlank((CharSequence)cronQuartzJob.cronExpression())) {
                throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u6ca1\u6709\u8bbe\u7f6eCron\u8868\u8fbe\u5f0f");
            }
            CronTrigger cronTrigger = this.getCronTrigger(name, cronQuartzJob.description(), cronQuartzJob.cronExpression());
            JobDetail jobDetail = this.getJobDetail(name, cronQuartzJob.description(), jobClass);
            this.scheduleJob(name, jobDetail, (Trigger)cronTrigger);
        }
    }

    public void add(ConfigureQuartzJob configureQuartzJob, Class<? extends Job> jobClass) throws CommonException {
        String name = this.getJobName(configureQuartzJob.name(), jobClass);
        if (StringUtils.isNotBlank((CharSequence)name)) {
            QuartzJobInfo jobInfo = this.getQuartzJobInfo(name);
            if (null != jobInfo) {
                boolean oper = true;
                if (null != jobInfo.getProfile() && jobInfo.getProfile().length > 0) {
                    oper = SpringContext.get().getEnvironment().acceptsProfiles(Profiles.of((String[])jobInfo.getProfile()));
                }
                if (oper && StringUtils.isNotBlank((CharSequence)jobInfo.getEnabledProperty())) {
                    String strEnabledProperty = SpringContext.get().getEnvironment().getProperty(jobInfo.getEnabledProperty());
                    oper = StringUtils.isNotBlank((CharSequence)strEnabledProperty) ? BooleanUtils.toBoolean((String)strEnabledProperty) : jobInfo.isEnabledMatchIfMissing();
                }
                if (oper) {
                    if (jobInfo.isCronExpression()) {
                        String cronExpression = (String)DataConvertUtils.convertValue((ClassType)ClassType.String, (Object)jobInfo.getValue());
                        if (StringUtils.isBlank((CharSequence)cronExpression)) {
                            throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u6ca1\u6709\u8bbe\u7f6eCron\u8868\u8fbe\u5f0f");
                        }
                        CronTrigger cronTrigger = this.getCronTrigger(name, configureQuartzJob.description(), cronExpression);
                        JobDetail jobDetail = this.getJobDetail(name, configureQuartzJob.description(), jobClass);
                        this.scheduleJob(name, jobDetail, (Trigger)cronTrigger);
                    } else {
                        if (null == jobInfo.getType()) {
                            throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u7684\u89e6\u53d1\u5668\u7c7b\u578b\u4e3a\u7a7a");
                        }
                        Integer interval = (Integer)DataConvertUtils.convertValue((ClassType)ClassType.Int, (Object)jobInfo.getValue());
                        if (null == interval || interval <= 0) {
                            throw new CommonException("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u7684\u95f4\u9694\u5fc5\u987b\u5927\u4e8e\u96f6");
                        }
                        SimpleTrigger simpleTrigger = this.getSimpleTrigger(name, configureQuartzJob.description(), jobInfo.getType(), interval, jobInfo.isImmediately());
                        JobDetail jobDetail = this.getJobDetail(name, configureQuartzJob.description(), jobClass);
                        this.scheduleJob(name, jobDetail, (Trigger)simpleTrigger);
                    }
                }
            } else {
                logger.warn("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u6ca1\u6709\u76f8\u5e94\u7684\u914d\u7f6e\u4fe1\u606f");
            }
        }
    }

    private JobDetail getJobDetail(String name, String description, Class<? extends Job> jobClass) {
        JobBuilder jobBuilder = JobBuilder.newJob(jobClass).withIdentity(new JobKey(name, QUARTZ_GROUP));
        if (StringUtils.isNotBlank((CharSequence)description)) {
            jobBuilder = jobBuilder.withDescription(description);
        }
        return jobBuilder.build();
    }

    private CronTrigger getCronTrigger(String name, String description, String cronExpression) {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(new TriggerKey(name, QUARTZ_GROUP)).withSchedule((ScheduleBuilder)cronScheduleBuilder);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            triggerBuilder = triggerBuilder.withDescription(description);
        }
        return (CronTrigger)triggerBuilder.build();
    }

    private SimpleTrigger getSimpleTrigger(String name, String description, TriggerType type, int interval, boolean immediately) throws CommonException {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule().repeatForever();
        if (type == TriggerType.Day) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInMilliseconds(86400000L * (long)interval);
        } else if (type == TriggerType.Hour) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInHours(interval);
        } else if (type == TriggerType.Minute) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInMinutes(interval);
        } else if (type == TriggerType.Second) {
            simpleScheduleBuilder = simpleScheduleBuilder.withIntervalInSeconds(interval);
        } else {
            throw new CommonException("\u672a\u77e5\u7684\u89e6\u53d1\u5668\u7c7b\u578b'" + type.toString() + "'");
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(new TriggerKey(name, QUARTZ_GROUP)).withSchedule((ScheduleBuilder)simpleScheduleBuilder);
        if (StringUtils.isNotBlank((CharSequence)description)) {
            triggerBuilder = triggerBuilder.withDescription(description);
        }
        if (immediately) {
            triggerBuilder = triggerBuilder.startNow();
        } else {
            long nextInterval = 0L;
            if (type == TriggerType.Day) {
                nextInterval = 86400000L * (long)interval;
            } else if (type == TriggerType.Hour) {
                nextInterval = 3600000L * (long)interval;
            } else if (type == TriggerType.Minute) {
                nextInterval = 60000L * (long)interval;
            } else if (type == TriggerType.Second) {
                nextInterval = (long)interval * 1000L;
            } else {
                throw new CommonException("\u672a\u77e5\u7684\u89e6\u53d1\u5668\u7c7b\u578b'" + type.toString() + "'");
            }
            Date startTime = new Date(new Date().getTime() + nextInterval);
            triggerBuilder = triggerBuilder.startAt(startTime);
        }
        return (SimpleTrigger)triggerBuilder.build();
    }

    private void scheduleJob(String name, JobDetail jobDetail, Trigger trigger) throws CommonException {
        try {
            if (!this.scheduler.isStarted()) {
                this.scheduler.start();
            }
            logger.debug("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u52a0\u5165\u5b9a\u65f6\u5668");
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    private String getJobName(String name, Class<? extends Job> jobClass) throws CommonException {
        String result = name;
        if (StringUtils.isBlank((CharSequence)result)) {
            result = jobClass.getSimpleName();
        }
        try {
            if (this.scheduler.checkExists(new JobKey(name, QUARTZ_GROUP))) {
                logger.warn("\u5b9a\u65f6\u4f5c\u4e1a'" + name + "'\u5df2\u7ecf\u5b58\u5728");
                return null;
            }
            return result;
        }
        catch (SchedulerException e) {
            throw ExceptionWrapUtils.wrap((Throwable)e);
        }
    }

    private QuartzJobInfo getQuartzJobInfo(String name) {
        QuartzJobInfo result = null;
        if (null != this.quartzProperties.getJobs()) {
            for (QuartzJobInfo jobInfo : this.quartzProperties.getJobs()) {
                if (!name.equals(jobInfo.getName())) continue;
                result = jobInfo;
                break;
            }
        }
        return result;
    }
}

