/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.quartz.service;

import jakarta.annotation.PostConstruct;
import java.util.List;
import org.cattleframework.aop.utils.ReflectionsFactory;
import org.cattleframework.exception.CommonException;
import org.cattleframework.exception.ExceptionWrapUtils;
import org.cattleframework.quartz.annotation.ConfigureQuartzJob;
import org.cattleframework.quartz.annotation.CronQuartzJob;
import org.cattleframework.quartz.annotation.QuartzJob;
import org.cattleframework.quartz.job.Job;
import org.cattleframework.quartz.service.QuartzService;

public class QuartzServiceInitializer {
    private final QuartzService quartzService;

    public QuartzServiceInitializer(QuartzService quartzService) {
        this.quartzService = quartzService;
    }

    @PostConstruct
    public void initialize() {
        List jobClasses = ReflectionsFactory.getSubTypesOf(Job.class);
        jobClasses.forEach(jobClass -> {
            try {
                QuartzJob quartzJob = jobClass.getAnnotation(QuartzJob.class);
                if (quartzJob != null) {
                    this.quartzService.add(quartzJob, (Class<? extends Job>)jobClass);
                    return;
                }
                CronQuartzJob cronQuartzJob = jobClass.getAnnotation(CronQuartzJob.class);
                if (cronQuartzJob != null) {
                    this.quartzService.add(cronQuartzJob, (Class<? extends Job>)jobClass);
                    return;
                }
                ConfigureQuartzJob configureQuartzJob = jobClass.getAnnotation(ConfigureQuartzJob.class);
                if (configureQuartzJob != null) {
                    this.quartzService.add(configureQuartzJob, (Class<? extends Job>)jobClass);
                    return;
                }
            }
            catch (CommonException e) {
                throw ExceptionWrapUtils.wrapRuntime((Throwable)e);
            }
        });
    }
}

