/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.auxiliary;

/**
 * 环境工具
 * 
 * @author orange
 *
 */
public class EnvUtils {

    public static String getEnvValue(String value) {
	if (org.apache.commons.lang3.StringUtils.isBlank(value)) {
	    return value;
	}
	StringTemplate st = new StringTemplate(value, StringTemplate.REGEX_PATTERN_JAVA_STYLE);
	String[] envVars = st.getVariables();
	for (int i = 0; i < envVars.length; i++) {
	    String val = System.getProperty(envVars[i]);
	    if (org.apache.commons.lang3.StringUtils.isEmpty(val)) {
		val = System.getenv(envVars[i]);
	    }
	    if (org.apache.commons.lang3.StringUtils.isNotEmpty(val)) {
		st.setVariable(envVars[i], val);
	    }
	}
	return st.getParseResult();
    }
}