/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.auxiliary;

import java.util.Map;

/**
 * Map工具
 * 
 * @author orange
 *
 */
public class MapUtils {

    public static <K, V> V getObject(final Map<? super K, V> map, final K key) {
	return getObject(map, key, null);
    }

    public static <K, V> V getObject(final Map<? super K, V> map, final K key, final V defaultValue) {
	if (map != null && map.containsKey(key)) {
	    return map.get(key);
	}
	return defaultValue;
    }
}