/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.cache.caffeine;

import org.cattleframework.utils.cache.Cache;

/**
 * Caffeine缓存
 * 
 * @author orange
 *
 */
public class CaffeineCache implements Cache {

    private com.github.benmanes.caffeine.cache.Cache<Object, Object> cache;

    public CaffeineCache(com.github.benmanes.caffeine.cache.Cache<Object, Object> cache) {
	this.cache = cache;
    }

    @Override
    public Object get(String key) {
	return cache.getIfPresent(key);
    }

    @Override
    public void put(String key, Object value) {
	cache.put(key, value);
    }

    @Override
    public void remove(String key) {
	cache.invalidate(key);
    }

    @Override
    public void clear() {
	cache.invalidateAll();
    }
}