/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.redis;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.cattleframework.exception.CommonRuntimeException;
import org.cattleframework.utils.auxiliary.CompressUtils;
import org.cattleframework.utils.auxiliary.ObjectUtils;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

/**
 * 定制Redis序列化
 * 
 * @author orange
 *
 */
public class CustomRedisSerializer implements RedisSerializer<Object> {

    @Override
    public byte[] serialize(Object object) throws SerializationException {
	byte[] bytes = ObjectUtils.serialize(object);
	return StringUtils
		.getBytesUtf8(Hex.encodeHexString(CompressUtils.compress(CompressorStreamFactory.GZIP, bytes)));
    }

    @Override
    public Object deserialize(byte[] bytes) throws SerializationException {
	if (bytes == null || bytes.length == 0) {
	    return null;
	}
	try {
	    return ObjectUtils.deserialize(CompressUtils.decompress(CompressorStreamFactory.GZIP,
		    Hex.decodeHex(StringUtils.newStringUtf8(bytes))));
	} catch (DecoderException e) {
	    throw new CommonRuntimeException("不能够被解码:" + e.getMessage(), e);
	}
    }
}