/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.auxiliary;

import java.math.BigDecimal;

/**
 * 数值工具
 * 
 * @author orange
 *
 */
public final class NumberUtils {

    private NumberUtils() {
    }

    public static BigDecimal toBigDecimal(String strVal) {
	BigDecimal result = null;
	if (org.apache.commons.lang3.StringUtils.isNotBlank(strVal)) {
	    try {
		result = org.apache.commons.lang3.math.NumberUtils.createBigDecimal(strVal);
	    } catch (NumberFormatException e) {
	    }
	}
	return result;
    }
}