/*
 * Copyright (C) 2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cattleframework.utils.reflect.constant;

/**
 * 类的类型
 * 
 * @author orange
 *
 */
public enum ClassType {

    /**
     * 数组
     */
    Array,
    /**
     * 枚举
     */
    Enum,
    /**
     * 长整型
     */
    Long,
    /**
     * 整型
     */
    Int,
    /**
     * 双精度
     */
    Double,
    /**
     * 字符串
     */
    String,
    /**
     * 布尔值
     */
    Boolean,
    /**
     * 日期
     */
    Date,
    /**
     * Sql日期
     */
    SqlDate,
    /**
     * 时间戳
     */
    Timestamp,
    /**
     * 时间
     */
    Time,
    /**
     * List
     */
    List,
    /**
     * Map
     */
    Map,
    /**
     * 字节
     */
    Byte,
    /**
     * 字符
     */
    Char,
    /**
     * 短整型
     */
    Short,
    /**
     * 对象
     */
    Object,
    /**
     * 类
     */
    Class,
    /**
     * 类对象
     */
    ClassObject,
    /**
     * Big Decimal
     */
    BigDecimal,
    /**
     * Big Integer
     */
    BigInteger,
    /**
     * 空值
     */
    Null
}