/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery;

import com.fasterxml.jackson.core.type.TypeReference;
import feign.FeignException;
import feign.Request;
import feign.RetryableException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.cattleframework.cloud.discovery.CommunicateProperties;
import org.cattleframework.cloud.discovery.DiscoveryInfoProperties;
import org.cattleframework.cloud.discovery.LoadBalancerProperties;
import org.cattleframework.cloud.discovery.enhancement.EnhancementConfiguration;
import org.cattleframework.cloud.discovery.enhancement.context.StaticDataManager;
import org.cattleframework.cloud.discovery.event.ServiceRegistryEvent;
import org.cattleframework.cloud.discovery.reflect.ServiceRegistryAspect;
import org.cattleframework.utils.auxiliary.JacksonUtils;
import org.cattleframework.utils.exception.BaseExceptionCustomizer;
import org.cattleframework.utils.exception.ExceptionProcessResponse;
import org.cattleframework.utils.http.RestTemplateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.FeignBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration
@EnableDiscoveryClient
@EnableConfigurationProperties(value={DiscoveryInfoProperties.class, CommunicateProperties.class, LoadBalancerProperties.class})
@Import(value={EnhancementConfiguration.class})
public class DiscoveryAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DiscoveryAutoConfiguration.class);

    @Bean
    public ServiceRegistryAspect serviceRegistryAspect(@Nullable List<ServiceRegistryEvent> serviceRegistryEvents) {
        return new ServiceRegistryAspect(serviceRegistryEvents);
    }

    @Bean
    public StaticDataManager staticDataManager(DiscoveryInfoProperties discoveryInfoProperties) {
        return new StaticDataManager(discoveryInfoProperties);
    }

    static class NotReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NotReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        private static final class ReactiveWebApplication {
            private ReactiveWebApplication() {
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={NotReactiveWebApplicationCondition.class})
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    public static class RestTemplateConfig {
        @Bean(value={"cloudRestTemplate"})
        @LoadBalanced
        @ConditionalOnMissingBean(name={"cloudRestTemplate"})
        public RestTemplate cloudRestTemplate(RestTemplateBuilder restTemplateBuilder, CommunicateProperties communicateProperties) {
            long connectTimeout = communicateProperties.getConnectTimeout() < 0L ? 5L : communicateProperties.getConnectTimeout();
            long readTimeout = communicateProperties.getReadTimeout() < 0L ? 5L : communicateProperties.getReadTimeout();
            logger.debug("RestTemplate\u8bbe\u7f6e\u7684\u8fde\u63a5\u8d85\u65f6:{}\u79d2,\u8bfb\u53d6\u8d85\u65f6:{}\u79d2", (Object)connectTimeout, (Object)readTimeout);
            restTemplateBuilder = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(connectTimeout)).setReadTimeout(Duration.ofSeconds(readTimeout));
            return restTemplateBuilder.build();
        }

        @Bean(value={"cloudRestTemplateUtils"})
        @ConditionalOnMissingBean(name={"cloudRestTemplateUtils"})
        public RestTemplateUtils cloudRestTemplateUtils(@Qualifier(value="cloudRestTemplate") RestTemplate restTemplate) {
            return new RestTemplateUtils(restTemplate);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"feign.Feign"})
    public static class FeignConfig {
        @Bean
        public FeignBuilderCustomizer feignBuilderCustomizer(CommunicateProperties communicateProperties) {
            long connectTimeout = communicateProperties.getConnectTimeout() < 0L ? 5L : communicateProperties.getConnectTimeout();
            long readTimeout = communicateProperties.getReadTimeout() < 0L ? 5L : communicateProperties.getReadTimeout();
            logger.debug("Feign\u8bbe\u7f6e\u7684\u8fde\u63a5\u8d85\u65f6:{}\u79d2,\u8bfb\u53d6\u8d85\u65f6:{}\u79d2", (Object)connectTimeout, (Object)readTimeout);
            return customizer -> customizer.options(new Request.Options(connectTimeout, TimeUnit.SECONDS, readTimeout, TimeUnit.SECONDS, true));
        }

        @Bean
        public BaseExceptionCustomizer feignExceptionCustomizer() {
            return new BaseExceptionCustomizer(new Class[]{FeignException.class}){

                public ExceptionProcessResponse processException(Throwable exception) {
                    Map exceptionResponseMap;
                    Collection responseHeaderValues;
                    Map responseHeaders;
                    FeignException feignException = (FeignException)exception;
                    int status = feignException.status();
                    String message = exception.getMessage();
                    String response = feignException.contentUTF8();
                    Integer exceptionCode = null;
                    if (StringUtils.isNotBlank((CharSequence)response) && MapUtils.isNotEmpty((Map)(responseHeaders = feignException.responseHeaders())) && responseHeaders.containsKey("source") && CollectionUtils.isNotEmpty((Collection)(responseHeaderValues = (Collection)responseHeaders.get("source"))) && responseHeaderValues.contains("cattle") && MapUtils.isNotEmpty((Map)(exceptionResponseMap = (Map)JacksonUtils.toObject((String)response, (TypeReference)new TypeReference<Map<String, Object>>(){})))) {
                        if (exceptionResponseMap.containsKey("error-code")) {
                            exceptionCode = NumberUtils.toInt((String)exceptionResponseMap.get("error-code").toString());
                        }
                        if (exceptionResponseMap.containsKey("message")) {
                            message = exceptionResponseMap.get("message").toString();
                        }
                        if (exceptionResponseMap.containsKey("response")) {
                            response = exceptionResponseMap.get("response").toString();
                        }
                    }
                    if (status == -1 && feignException instanceof RetryableException) {
                        status = HttpStatus.SERVICE_UNAVAILABLE.value();
                    }
                    return new ExceptionProcessResponse(Integer.valueOf(status), exceptionCode, message, response);
                }
            };
        }
    }
}

