/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.aop.event.ContextInitializeEvent;
import org.cattleframework.aop.processor.SortedBeanPostProcessor;
import org.cattleframework.aop.utils.ServiceLoaderUtils;
import org.cattleframework.cloud.discovery.BaseCloudDiscoveryProperties;
import org.cattleframework.cloud.discovery.DiscoveryInfoProperties;
import org.cattleframework.cloud.discovery.LoadBalancerProperties;
import org.cattleframework.cloud.discovery.processor.DiscoveryPropertiesProcessor;
import org.cattleframework.cloud.discovery.reflect.DiscoveryClientProxy;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.loadbalancer.cache.LoadBalancerCacheProperties;
import org.springframework.core.env.Environment;

public class DiscoveryInitialize
implements ContextInitializeEvent {
    public void execute(final ConfigurableListableBeanFactory beanFactory, final Environment environment) throws Throwable {
        final List discoveryPropertiesProcessors = ServiceLoaderUtils.getService(DiscoveryPropertiesProcessor.class);
        String processorName = StringUtils.uncapitalize((String)this.getClass().getSimpleName()) + "Processor";
        beanFactory.registerSingleton(processorName, (Object)new SortedBeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                List<DiscoveryPropertiesProcessor> discoveryPropertiesProcessorLst;
                if (bean instanceof DiscoveryClient) {
                    DiscoveryClient target = (DiscoveryClient)bean;
                    return DiscoveryClientProxy.getDiscoveryClientProxy(beanFactory, target);
                }
                if (bean instanceof LoadBalancerCacheProperties) {
                    LoadBalancerCacheProperties loadBalancerCacheProperties = (LoadBalancerCacheProperties)bean;
                    LoadBalancerProperties loadBalancerProperties = (LoadBalancerProperties)beanFactory.getBean(LoadBalancerProperties.class);
                    if (loadBalancerProperties.isCache()) {
                        loadBalancerCacheProperties.setTtl(Duration.ofSeconds(loadBalancerProperties.getTimeToLive()));
                        loadBalancerCacheProperties.setCapacity(loadBalancerProperties.getCapacity());
                    }
                    return loadBalancerCacheProperties;
                }
                if (CollectionUtils.isNotEmpty((Collection)discoveryPropertiesProcessors) && CollectionUtils.isNotEmpty(discoveryPropertiesProcessorLst = discoveryPropertiesProcessors.stream().filter(p -> p.needProcess(bean.getClass())).collect(Collectors.toList()))) {
                    DiscoveryInfoProperties discoveryInfoProperties = (DiscoveryInfoProperties)beanFactory.getBean(DiscoveryInfoProperties.class);
                    discoveryPropertiesProcessorLst.forEach(discoveryPropertiesProcessor -> discoveryPropertiesProcessor.process(beanFactory, environment, bean, discoveryInfoProperties, (BaseCloudDiscoveryProperties)beanFactory.getBean(discoveryPropertiesProcessor.getSourcePropertiesClass())));
                }
                return bean;
            }

            public int getOrder() {
                return Integer.MIN_VALUE;
            }
        });
    }
}

