/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.List;
import org.cattleframework.cloud.discovery.enhancement.feign.EnhancedLoadBalancerFeignRequestTransformer;
import org.cattleframework.cloud.discovery.enhancement.feign.FeignBeanPostProcessor;
import org.cattleframework.cloud.discovery.enhancement.filter.ReactiveFilter;
import org.cattleframework.cloud.discovery.enhancement.filter.ServletFilter;
import org.cattleframework.cloud.discovery.enhancement.plugin.DefaultPluginRunner;
import org.cattleframework.cloud.discovery.enhancement.plugin.Plugin;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.discovery.enhancement.resttemplate.RestTemplateInterceptor;
import org.cattleframework.cloud.discovery.enhancement.resttemplate.RestTemplateLoadBalancerRequestTransformer;
import org.cattleframework.cloud.discovery.enhancement.scg.GatewayFilter;
import org.cattleframework.cloud.discovery.enhancement.webclient.WebClientExchangeFilterFunction;
import org.cattleframework.cloud.discovery.enhancement.webclient.WebClientLoadBalancerClientRequestTransformer;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.client.loadbalancer.RestTemplateCustomizer;
import org.springframework.cloud.client.loadbalancer.reactive.WebClientCustomizer;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"cattle.cloud.enhancement.enabled"}, havingValue="true", matchIfMissing=true)
public class EnhancementConfiguration {
    @Bean
    @Lazy
    public PluginRunner pluginRunner(@Nullable List<Plugin> plugins, @Nullable Registration registration) {
        return new DefaultPluginRunner(plugins, registration);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class ReactiveFilterConfig {
        @Bean
        public ReactiveFilter reactiveFilter(@Lazy PluginRunner pluginRunner) {
            return new ReactiveFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public static class ServletFilterConfig {
        @Bean
        public FilterRegistrationBean<ServletFilter> servletFilterRegistrationBean(ServletFilter servletFilter) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)servletFilter, new ServletRegistrationBean[0]);
            filterRegistrationBean.setDispatcherTypes(DispatcherType.ASYNC, new DispatcherType[]{DispatcherType.ERROR, DispatcherType.FORWARD, DispatcherType.INCLUDE, DispatcherType.REQUEST});
            filterRegistrationBean.setOrder(-2147483638);
            return filterRegistrationBean;
        }

        @Bean
        public ServletFilter servletFilter(@Lazy PluginRunner pluginRunner) {
            return new ServletFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.gateway.config.GatewayAutoConfiguration"})
    @Role(value=2)
    public static class GatewayAutoConfiguration {
        @Bean
        @ConditionalOnClass(name={"org.springframework.cloud.gateway.filter.GlobalFilter"})
        public GatewayFilter gatewayFilter(@Lazy PluginRunner pluginRunner) {
            return new GatewayFilter(pluginRunner);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.reactive.function.client.WebClient"})
    public static class WebClientAutoConfiguration {
        @Bean
        public WebClientExchangeFilterFunction webClientExchangeFilterFunction(@Lazy PluginRunner pluginRunner) {
            return new WebClientExchangeFilterFunction(pluginRunner);
        }

        @Bean
        @ConditionalOnMissingBean
        public WebClientCustomizer webClientCustomizer(WebClientExchangeFilterFunction webClientExchangeFilterFunction) {
            return webClientBuilder -> webClientBuilder.filter((ExchangeFilterFunction)webClientExchangeFilterFunction);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.reactive.LoadBalancerClientRequestTransformer"})
        public WebClientLoadBalancerClientRequestTransformer webClientLoadBalancerClientRequestTransformer() {
            return new WebClientLoadBalancerClientRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.web.client.RestTemplate"})
    public static class RestTemplateAutoConfiguration {
        @Bean
        public RestTemplateInterceptor restTemplateInterceptor(@Lazy PluginRunner pluginRunner) {
            return new RestTemplateInterceptor(pluginRunner);
        }

        @Bean
        @ConditionalOnMissingBean
        public RestTemplateCustomizer restTemplateCustomizer(LoadBalancerInterceptor loadBalancerInterceptor, RestTemplateInterceptor restTemplateInterceptor) {
            return restTemplate -> {
                ArrayList<Object> list = new ArrayList<Object>(restTemplate.getInterceptors());
                list.add(loadBalancerInterceptor);
                list.add(restTemplateInterceptor);
                restTemplate.setInterceptors(list);
            };
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.LoadBalancerRequestTransformer"})
        public RestTemplateLoadBalancerRequestTransformer restTemplateLoadBalancerRequestTransformer() {
            return new RestTemplateLoadBalancerRequestTransformer();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @AutoConfigureBefore(name={"org.springframework.cloud.openfeign.FeignAutoConfiguration"})
    @Role(value=2)
    public static class FeignClientAutoConfiguration {
        @Bean
        public FeignBeanPostProcessor feignBeanPostProcessor(@Lazy PluginRunner pluginRunner) {
            return new FeignBeanPostProcessor(pluginRunner);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnClass(name={"org.springframework.cloud.openfeign.loadbalancer.LoadBalancerFeignRequestTransformer"})
        public EnhancedLoadBalancerFeignRequestTransformer enhancedLoadBalancerFeignRequestTransformer() {
            return new EnhancedLoadBalancerFeignRequestTransformer();
        }
    }
}

