/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DataContext {
    private static final String FRAGMENT_TRANSITIVE = "transitive";
    private static final String FRAGMENT_DISPOSABLE = "disposable";
    private static final String FRAGMENT_UPSTREAM_DISPOSABLE = "upstream-disposable";
    private static final String FRAGMENT_RAW_TRANSHEADERS = "trans-headers";
    private static final String FRAGMENT_RAW_TRANSHEADERS_KV = "trans-headers-kv";
    private final Map<String, Map<String, String>> fragmentContexts = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<String, Object> loadbalancerData = new ConcurrentHashMap<String, Object>();

    public Map<String, String> getCustomMetadata() {
        Map<String, String> transitiveMetadata = this.getTransitiveMetadata();
        Map<String, String> disposableMetadata = this.getDisposableMetadata();
        HashMap customMetadata = new HashMap(0);
        transitiveMetadata.forEach((key, value) -> {
            if (!disposableMetadata.containsKey(key)) {
                customMetadata.put(key, value);
            }
        });
        return Collections.unmodifiableMap(customMetadata);
    }

    public void setTransitiveMetadata(Map<String, String> transitiveMetadata) {
        this.putFragmentContext(FRAGMENT_TRANSITIVE, Collections.unmodifiableMap(transitiveMetadata));
    }

    public void setDisposableMetadata(Map<String, String> disposableMetadata) {
        this.putFragmentContext(FRAGMENT_DISPOSABLE, Collections.unmodifiableMap(disposableMetadata));
    }

    public Map<String, String> getDisposableMetadata() {
        return this.getFragmentContext(FRAGMENT_DISPOSABLE);
    }

    public Map<String, String> getTransitiveMetadata() {
        return this.getFragmentContext(FRAGMENT_TRANSITIVE);
    }

    public Map<String, String> getFragmentContext(String fragment) {
        Map<String, String> fragmentContext = this.fragmentContexts.get(fragment);
        if (fragmentContext == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(fragmentContext);
    }

    public void putFragmentContext(String fragment, Map<String, String> context) {
        this.fragmentContexts.put(fragment, context);
    }

    public void setUpstreamDisposableMetadata(Map<String, String> upstreamDisposableMetadata) {
        this.putFragmentContext(FRAGMENT_UPSTREAM_DISPOSABLE, Collections.unmodifiableMap(upstreamDisposableMetadata));
    }

    public void setTransHeader(String key, String value) {
        this.putContext(FRAGMENT_RAW_TRANSHEADERS_KV, key, value);
    }

    public Map<String, String> getTransHeaders() {
        return this.getFragmentContext(FRAGMENT_RAW_TRANSHEADERS);
    }

    public void setTransHeaders(String key, String value) {
        this.putContext(FRAGMENT_RAW_TRANSHEADERS, key, value);
    }

    public void putContext(String fragment, String key, String value) {
        Map<String, String> fragmentContext = this.fragmentContexts.get(fragment);
        if (fragmentContext == null) {
            fragmentContext = new ConcurrentHashMap<String, String>(0);
            this.fragmentContexts.put(fragment, fragmentContext);
        }
        fragmentContext.put(key, value);
    }

    public Map<String, String> getTransHeaderMap() {
        return this.getFragmentContext(FRAGMENT_RAW_TRANSHEADERS_KV);
    }

    public Map<String, Object> getLoadbalancerDataMap() {
        return this.loadbalancerData;
    }

    public void setLoadbalancerData(String key, Object value) {
        this.loadbalancerData.put(key, value);
    }
}

