/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.aop.SpringContext;
import org.cattleframework.cloud.discovery.enhancement.context.DataContext;
import org.cattleframework.cloud.discovery.enhancement.context.StaticDataManager;

public final class DataContextHolder {
    private static final ThreadLocal<DataContext> DATA_CONTEXT = new InheritableThreadLocal<DataContext>();
    private static StaticDataManager staticDataManager;

    private DataContextHolder() {
    }

    public static DataContext get() {
        if (DATA_CONTEXT.get() != null) {
            return DATA_CONTEXT.get();
        }
        if (staticDataManager == null) {
            staticDataManager = (StaticDataManager)SpringContext.get().getBeanFactory().getBean(StaticDataManager.class);
        }
        DataContext dataContext = new DataContext();
        dataContext.setTransitiveMetadata(staticDataManager.getMergedStaticTransitiveMetadata());
        dataContext.setDisposableMetadata(staticDataManager.getMergedStaticDisposableMetadata());
        String transHeader = staticDataManager.getTransHeader();
        if (StringUtils.isNotBlank((CharSequence)transHeader)) {
            dataContext.setTransHeaders(transHeader, "");
        }
        DATA_CONTEXT.set(dataContext);
        return DATA_CONTEXT.get();
    }

    public static void init(Map<String, String> dynamicTransitiveMetadata, Map<String, String> dynamicDisposableMetadata) {
        DataContextHolder.remove();
        DataContext dataContext = DataContextHolder.get();
        if (MapUtils.isNotEmpty(dynamicTransitiveMetadata)) {
            Map<String, String> staticTransitiveMetadata = dataContext.getTransitiveMetadata();
            HashMap<String, String> mergedTransitiveMetadata = new HashMap<String, String>(0);
            mergedTransitiveMetadata.putAll(staticTransitiveMetadata);
            mergedTransitiveMetadata.putAll(dynamicTransitiveMetadata);
            dataContext.setTransitiveMetadata(Collections.unmodifiableMap(mergedTransitiveMetadata));
        }
        if (MapUtils.isNotEmpty(dynamicDisposableMetadata)) {
            HashMap<String, String> mergedUpstreamDisposableMetadata = new HashMap<String, String>(dynamicDisposableMetadata);
            dataContext.setUpstreamDisposableMetadata(Collections.unmodifiableMap(mergedUpstreamDisposableMetadata));
        }
        Map<String, String> staticDisposableMetadata = dataContext.getDisposableMetadata();
        dataContext.setDisposableMetadata(Collections.unmodifiableMap(staticDisposableMetadata));
        DataContextHolder.set(dataContext);
    }

    public static void set(DataContext dataContext) {
        DATA_CONTEXT.set(dataContext);
    }

    public static void remove() {
        DATA_CONTEXT.remove();
    }
}

