/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cattleframework.cloud.discovery.DiscoveryInfoProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticDataManager {
    private static final Logger logger = LoggerFactory.getLogger(StaticDataManager.class);
    private static final String ENV_METADATA_PREFIX = "METADATA_CONTENT_";
    private static final int ENV_METADATA_PREFIX_LENGTH = "METADATA_CONTENT_".length();
    private static final String ENV_METADATA_CONTENT_TRANSITIVE = "METADATA_CONTENT_TRANSITIVE";
    private static final String ENV_METADATA_CONTENT_DISPOSABLE = "METADATA_CONTENT_DISPOSABLE";
    private static final String ENV_TRANSHEADERS = "TRANSHEADERS";
    private Map<String, String> envMetadata;
    private Map<String, String> envTransitiveMetadata;
    private Map<String, String> envDisposableMetadata;
    private String envTransHeaders;
    private Map<String, String> configMetadata;
    private Map<String, String> configTransitiveMetadata;
    private Map<String, String> configDisposableMetadata;
    private String configTransHeaders;
    private Map<String, String> mergedStaticMetadata;
    private Map<String, String> mergedStaticTransitiveMetadata;
    private Map<String, String> mergedStaticDisposableMetadata;

    public StaticDataManager(DiscoveryInfoProperties discoveryInfoProperties) {
        this.parseConfigMetadata(discoveryInfoProperties);
        this.parseEnvMetadata();
        this.merge();
        logger.info("Loaded static metadata info. {}", (Object)this);
    }

    private void parseEnvMetadata() {
        String[] keyArr;
        String[] keyArr2;
        Map<String, String> allEnvs = System.getenv();
        this.envMetadata = new HashMap<String, String>(0);
        for (Map.Entry<String, String> entry : allEnvs.entrySet()) {
            String[] key = entry.getKey();
            if (StringUtils.isBlank((CharSequence)key) || ENV_METADATA_CONTENT_TRANSITIVE.equals(key) || ENV_METADATA_CONTENT_DISPOSABLE.equals(key)) continue;
            String value = entry.getValue();
            if (!key.startsWith(ENV_METADATA_PREFIX) && !ENV_TRANSHEADERS.equals(key)) continue;
            String sourceKey = "";
            if (ENV_TRANSHEADERS.equals(key)) {
                if (StringUtils.isNotBlank((CharSequence)value)) {
                    this.envTransHeaders = value;
                }
            } else {
                sourceKey = StringUtils.substring((String)key, (int)ENV_METADATA_PREFIX_LENGTH);
                this.envMetadata.put(sourceKey, value);
            }
            logger.info("resolve metadata from env. key = {}, value = {}", (Object)sourceKey, (Object)value);
        }
        this.envMetadata = Collections.unmodifiableMap(this.envMetadata);
        this.envTransitiveMetadata = new HashMap<String, String>(0);
        String transitiveKeys = allEnvs.get(ENV_METADATA_CONTENT_TRANSITIVE);
        if (StringUtils.isNotBlank((CharSequence)transitiveKeys) && (keyArr2 = StringUtils.split((String)transitiveKeys, (String)",")) != null && keyArr2.length > 0) {
            for (String key : keyArr2) {
                String value = this.envMetadata.get(key);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                this.envTransitiveMetadata.put(key, value);
            }
        }
        this.envTransitiveMetadata = Collections.unmodifiableMap(this.envTransitiveMetadata);
        this.envDisposableMetadata = new HashMap<String, String>(0);
        String disposableKeys = allEnvs.get(ENV_METADATA_CONTENT_DISPOSABLE);
        if (StringUtils.isNotBlank((CharSequence)disposableKeys) && (keyArr = StringUtils.split((String)disposableKeys, (String)",")) != null && keyArr.length > 0) {
            for (String key : keyArr) {
                String value = this.envMetadata.get(key);
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                this.envDisposableMetadata.put(key, value);
            }
        }
        this.envDisposableMetadata = Collections.unmodifiableMap(this.envDisposableMetadata);
    }

    private void parseConfigMetadata(DiscoveryInfoProperties discoveryInfoProperties) {
        Map<String, String> allMetadata = discoveryInfoProperties.getMetadata().getContent();
        List<String> transitiveKeys = discoveryInfoProperties.getMetadata().getTransitive();
        List<String> disposableKeys = discoveryInfoProperties.getMetadata().getDisposable();
        List<String> headers = discoveryInfoProperties.getHeaders();
        HashMap<String, String> transitiveResult = new HashMap<String, String>(0);
        for (String key : transitiveKeys) {
            if (!allMetadata.containsKey(key)) continue;
            transitiveResult.put(key, allMetadata.get(key));
        }
        HashMap<String, String> disposableResult = new HashMap<String, String>(0);
        for (String key : disposableKeys) {
            if (!allMetadata.containsKey(key)) continue;
            disposableResult.put(key, allMetadata.get(key));
        }
        this.configTransitiveMetadata = Collections.unmodifiableMap(transitiveResult);
        this.configDisposableMetadata = Collections.unmodifiableMap(disposableResult);
        this.configTransHeaders = CollectionUtils.isEmpty(headers) ? null : String.join((CharSequence)",", headers);
        this.configMetadata = Collections.unmodifiableMap(allMetadata);
    }

    private void merge() {
        HashMap<String, String> mergedMetadataResult = new HashMap<String, String>(0);
        mergedMetadataResult.putAll(this.configMetadata);
        mergedMetadataResult.putAll(this.envMetadata);
        this.mergedStaticMetadata = Collections.unmodifiableMap(mergedMetadataResult);
        HashMap<String, String> mergedTransitiveMetadataResult = new HashMap<String, String>(0);
        mergedTransitiveMetadataResult.putAll(this.configTransitiveMetadata);
        mergedTransitiveMetadataResult.putAll(this.envTransitiveMetadata);
        this.mergedStaticTransitiveMetadata = Collections.unmodifiableMap(mergedTransitiveMetadataResult);
        HashMap<String, String> mergedDisposableMetadataResult = new HashMap<String, String>(0);
        mergedDisposableMetadataResult.putAll(this.configDisposableMetadata);
        mergedDisposableMetadataResult.putAll(this.envDisposableMetadata);
        this.mergedStaticDisposableMetadata = Collections.unmodifiableMap(mergedDisposableMetadataResult);
    }

    public Map<String, String> getMergedStaticTransitiveMetadata() {
        return this.mergedStaticTransitiveMetadata;
    }

    public Map<String, String> getMergedStaticDisposableMetadata() {
        return this.mergedStaticDisposableMetadata;
    }

    public String getTransHeader() {
        HashSet transHeaderSet = new HashSet();
        Set transHeaderFromEnvSet = StringUtils.isNotBlank((CharSequence)this.envTransHeaders) ? Arrays.stream(this.envTransHeaders.split(",")).collect(Collectors.toSet()) : Collections.emptySet();
        Set transHeaderFromConfigSet = StringUtils.isNotBlank((CharSequence)this.configTransHeaders) ? Arrays.stream(this.configTransHeaders.split(",")).collect(Collectors.toSet()) : Collections.emptySet();
        transHeaderSet.addAll(transHeaderFromEnvSet);
        transHeaderSet.addAll(transHeaderFromConfigSet);
        return new ArrayList(transHeaderSet).stream().sorted().collect(Collectors.joining(","));
    }
}

