/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.feign;

import feign.Client;
import org.cattleframework.cloud.discovery.enhancement.feign.FeignClient;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.loadbalancer.blocking.client.BlockingLoadBalancerClient;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.LoadBalancerFeignRequestTransformer;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;

public class FeignBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private final PluginRunner pluginRunner;
    private BeanFactory beanFactory;

    public FeignBeanPostProcessor(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Client) {
            Client delegate;
            if ((bean instanceof RetryableFeignBlockingLoadBalancerClient || bean instanceof FeignBlockingLoadBalancerClient) && (delegate = bean instanceof RetryableFeignBlockingLoadBalancerClient ? ((RetryableFeignBlockingLoadBalancerClient)bean).getDelegate() : ((FeignBlockingLoadBalancerClient)bean).getDelegate()) != null) {
                return new FeignBlockingLoadBalancerClient((Client)new FeignClient(delegate, this.pluginRunner), (LoadBalancerClient)this.beanFactory.getBean(BlockingLoadBalancerClient.class), (LoadBalancerClientFactory)this.beanFactory.getBean(LoadBalancerClientFactory.class), this.beanFactory.getBeanProvider(LoadBalancerFeignRequestTransformer.class).stream().toList());
            }
            return new FeignClient((Client)bean, this.pluginRunner);
        }
        return bean;
    }
}

