/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.cattleframework.cloud.discovery.enhancement.context.DataContextHolder;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginType;
import org.cattleframework.cloud.discovery.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.ResponseContext;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;

public class FeignClient
implements Client {
    private final Client delegate;
    private final PluginRunner pluginRunner;

    public FeignClient(Client target, PluginRunner pluginRunner) {
        this.delegate = (Client)Util.checkNotNull((Object)target, (String)"target", (Object[])new Object[0]);
        this.pluginRunner = pluginRunner;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        PluginContext pluginContext = new PluginContext();
        HttpHeaders requestHeaders = new HttpHeaders();
        request.headers().forEach((s, strings) -> requestHeaders.addAll(s, new ArrayList(strings)));
        URI url = URI.create(request.url());
        RequestContext requestContext = RequestContext.builder().httpHeaders(requestHeaders).httpMethod(HttpMethod.valueOf((String)request.httpMethod().name())).url(url).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        pluginContext.setTargetServiceInstance((ServiceInstance)DataContextHolder.get().getLoadbalancerDataMap().get("load_balancer_service_instance"), url);
        this.pluginRunner.run(PluginType.Client.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        try {
            Response response = this.delegate.execute(request, options);
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            HttpHeaders responseHeaders = new HttpHeaders();
            response.headers().forEach((s, strings) -> responseHeaders.addAll(s, new ArrayList(strings)));
            ResponseContext responseContext = ResponseContext.builder().httpStatus(response.status()).httpHeaders(responseHeaders).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Client.POST, pluginContext);
            Response response2 = response;
            return response2;
        }
        catch (IOException e) {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable(e);
            this.pluginRunner.run(PluginType.Client.EXCEPTION, pluginContext);
            throw e;
        }
        finally {
            this.pluginRunner.run(PluginType.Client.FINALLY, pluginContext);
        }
    }
}

