/*
 * Decompiled with CFR 0.152.
 */
package org.cattleframework.cloud.discovery.enhancement.filter;

import org.cattleframework.cloud.discovery.enhancement.plugin.PluginContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginRunner;
import org.cattleframework.cloud.discovery.enhancement.plugin.PluginType;
import org.cattleframework.cloud.discovery.enhancement.plugin.RequestContext;
import org.cattleframework.cloud.discovery.enhancement.plugin.ResponseContext;
import org.springframework.core.Ordered;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ReactiveFilter
implements WebFilter,
Ordered {
    private final PluginRunner pluginRunner;

    public ReactiveFilter(PluginRunner pluginRunner) {
        this.pluginRunner = pluginRunner;
    }

    public int getOrder() {
        return -2147483638;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        PluginContext pluginContext = new PluginContext();
        RequestContext requestContext = RequestContext.builder().httpHeaders(exchange.getRequest().getHeaders()).httpMethod(exchange.getRequest().getMethod()).url(exchange.getRequest().getURI()).build();
        pluginContext.setRequest(requestContext);
        pluginContext.setLocalServiceInstance(this.pluginRunner.getLocalServiceInstance());
        this.pluginRunner.run(PluginType.Server.PRE, pluginContext);
        long startMillis = System.currentTimeMillis();
        return chain.filter(exchange).doOnSuccess(v -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            ResponseContext responseContext = ResponseContext.builder().httpStatus(exchange.getResponse().getStatusCode() != null ? Integer.valueOf(exchange.getResponse().getStatusCode().value()) : null).httpHeaders(exchange.getResponse().getHeaders()).build();
            pluginContext.setResponse(responseContext);
            this.pluginRunner.run(PluginType.Server.POST, pluginContext);
        }).doOnError(e -> {
            pluginContext.setDelay(System.currentTimeMillis() - startMillis);
            pluginContext.setThrowable((Throwable)e);
            this.pluginRunner.run(PluginType.Server.EXCEPTION, pluginContext);
        }).doFinally(v -> this.pluginRunner.run(PluginType.Server.FINALLY, pluginContext));
    }
}

